
<div class="d-flex justify-content-between align-items-center mb-2">
  <h5>PO (Sotib olish buyurtmasi)</h5>
  <button class="btn btn-primary" onclick="openModal('poCreate')">+ Yangi</button>
</div>
<table class="table table-striped"><thead><tr><th>ID</th><th>Sana</th><th>Yetkazib beruvchi</th><th>Ombor</th><th>Status</th></tr></thead>
<tbody><?php foreach($po as $p): ?><tr>
  <td><?= $p['id'] ?></td><td><?= htmlspecialchars($p['po_date']) ?></td><td><?= htmlspecialchars($p['supplier']) ?></td><td><?= htmlspecialchars($p['warehouse_id']) ?></td><td><?= htmlspecialchars($p['status']) ?></td>
</tr><?php endforeach; ?></tbody></table>

<div class="modal" id="poCreate"><div class="modal-dialog modal-lg"><div class="modal-content">
  <div class="modal-header"><h5>PO yaratish</h5><button class="btn-close" onclick="closeModal('poCreate')"></button></div>
  <form method="post" action="<?= url('purchase/po/store') ?>" onsubmit="return poSyncItems()"><div class="modal-body">
    <div class="row g-2">
      <div class="col-md-4"><label class="form-label">Yetkazib beruvchi</label><select name="supplier_id" class="form-select"><?php foreach($sup as $s): ?><option value="<?= $s['id'] ?>"><?= htmlspecialchars($s['name']) ?></option><?php endforeach; ?></select></div>
      <div class="col-md-4"><label class="form-label">Ombor</label><select name="warehouse_id" class="form-select"><?php foreach($ware as $w): ?><option value="<?= $w['id'] ?>"><?= htmlspecialchars($w['name']) ?></option><?php endforeach; ?></select></div>
      <div class="col-md-4"><label class="form-label">Sana</label><input type="date" name="po_date" class="form-control" value="<?= date('Y-m-d') ?>"></div>
      <div class="col-md-12"><label class="form-label">Izoh</label><input name="notes" class="form-control"></div>
    </div><hr>
    <div class="table-responsive"><table class="table" id="poItems"><thead><tr><th>Mahsulot</th><th>Miqdor</th><th>Narx</th><th>Summa</th><th></th></tr></thead><tbody></tbody></table></div>
    <button class="btn btn-outline-primary" type="button" onclick="poAddRow()">+ Qator</button>
  </div><div class="modal-footer"><button class="btn btn-secondary" type="button" onclick="closeModal('poCreate')">Bekor</button><button class="btn btn-primary">Saqlash</button></div></form>
</div></div></div>

<script>
const poProducts = <?= json_encode($prod) ?>;
function poAddRow(){
  const tr=document.createElement('tr');
  tr.innerHTML=`<td><select class="form-select pprod">${poProducts.map(p=>`<option data-price="${p.price}" value="${p.id}">${p.code} — ${p.name}</option>`).join('')}</select></td>
  <td><input class="form-control pqty" type="number" value="1"></td>
  <td><input class="form-control pprice" type="number" step="0.01" value="0"></td>
  <td class="psum text-end">0</td>
  <td><button class="btn btn-sm btn-outline-danger" type="button" onclick="this.closest('tr').remove(); poRecalc();">×</button></td>`;
  poItems.querySelector('tbody').appendChild(tr);
  tr.querySelector('.pprod').addEventListener('change',e=>{tr.querySelector('.pprice').value=e.target.selectedOptions[0].dataset.price||0; poRecalc();});
  tr.querySelector('.pqty').addEventListener('input', poRecalc);
  tr.querySelector('.pprice').addEventListener('input', poRecalc);
  poRecalc();
}
function poRecalc(){ poItems.querySelectorAll('tbody tr').forEach(tr=>{ const q=parseFloat(tr.querySelector('.pqty').value||0); const p=parseFloat(tr.querySelector('.pprice').value||0); tr.querySelector('.psum').textContent=(q*p).toFixed(2); }); }
function poSyncItems(){
  const form=event.target; const items=[];
  poItems.querySelectorAll('tbody tr').forEach(tr=>{ const pid=parseInt(tr.querySelector('.pprod').value); const qty=parseFloat(tr.querySelector('.pqty').value||0); const price=parseFloat(tr.querySelector('.pprice').value||0);
    if(pid && qty>0) items.push({product_id:pid, qty:qty, price:price}); });
  const holder=document.createElement('div');
  items.forEach((it,i)=>{ ['product_id','qty','price'].forEach(k=>{ const inp=document.createElement('input'); inp.type='hidden'; inp.name=`items[${i}][${k}]`; inp.value=it[k]; holder.appendChild(inp); }); });
  form.appendChild(holder); return true;
}
</script>
