<?php
require_once __DIR__ . '/../app/lib/session.php';
require_once __DIR__ . '/../app/lib/helpers.php';
require_once __DIR__ . '/../app/config/database.php';

$action = $_GET['action'] ?? '';

switch ($action) {
  case 'login':
    require_post();
    $username = $_POST['username'] ?? '';
    $password = $_POST['password'] ?? '';
    if (!$username || !$password) {
      json_response(['error' => 'Missing credentials'], 422);
    }
    $stmt = $pdo->prepare("SELECT id, username, password_hash, full_name, role FROM users WHERE username = ? LIMIT 1");
    $stmt->execute([$username]);
    $user = $stmt->fetch();
    if (!$user || !password_verify($password, $user['password_hash'])) {
      json_response(['error' => 'Invalid username or password'], 401);
    }
    $_SESSION['user'] = [
      'id' => $user['id'],
      'username' => $user['username'],
      'full_name' => $user['full_name'],
      'role' => $user['role']
    ];
    $csrf = get_csrf_token();
    json_response(['message' => 'Logged in', 'csrf' => $csrf, 'user' => $_SESSION['user']]);
    break;

  case 'me':
    if (!empty($_SESSION['user'])) {
      $csrf = get_csrf_token();
      json_response(['user' => $_SESSION['user'], 'csrf' => $csrf]);
    } else {
      json_response(['user' => null], 200);
    }
    break;

  case 'logout':
    session_destroy();
    json_response(['message' => 'Logged out']);
    break;

  default:
    json_response(['error' => 'Unknown action'], 400);
}
