<?php
require_once __DIR__ . '/../app/lib/session.php';
require_once __DIR__ . '/../app/lib/helpers.php';
require_once __DIR__ . '/../app/config/database.php';

require_login();

$action = $_GET['action'] ?? 'list';

switch ($action) {
  case 'list':
    $q = trim($_GET['q'] ?? '');
    [$page, $per, $offset] = paginate_params();
    if ($q) {
      $stmt = $pdo->prepare("SELECT SQL_CALC_FOUND_ROWS * FROM products 
                              WHERE name LIKE :q OR sku LIKE :q 
                              ORDER BY id DESC LIMIT :offset, :per");
      $stmt->bindValue(':q', "%$q%");
      $stmt->bindValue(':offset', (int)$offset, PDO::PARAM_INT);
      $stmt->bindValue(':per', (int)$per, PDO::PARAM_INT);
      $stmt->execute();
    } else {
      $stmt = $pdo->prepare("SELECT SQL_CALC_FOUND_ROWS * FROM products ORDER BY id DESC LIMIT :offset, :per");
      $stmt->bindValue(':offset', (int)$offset, PDO::PARAM_INT);
      $stmt->bindValue(':per', (int)$per, PDO::PARAM_INT);
      $stmt->execute();
    }
    $data = $stmt->fetchAll();
    $total = $pdo->query("SELECT FOUND_ROWS() AS t")->fetch()['t'] ?? 0;
    json_response(['data' => $data, 'total' => (int)$total, 'page' => $page, 'per_page' => $per]);
    break;

  case 'get':
    $id = (int)($_GET['id'] ?? 0);
    $stmt = $pdo->prepare("SELECT * FROM products WHERE id = ?");
    $stmt->execute([$id]);
    $row = $stmt->fetch();
    if (!$row) json_response(['error' => 'Not found'], 404);
    json_response($row);
    break;

  case 'create':
    verify_csrf();
    require_post();
    $name = sanitize_text($_POST['name'] ?? '');
    $sku  = sanitize_text($_POST['sku'] ?? '');
    $price = (float)($_POST['price'] ?? 0);
    $stock = (int)($_POST['stock'] ?? 0);
    $notes = sanitize_text($_POST['notes'] ?? '');
    if (!$name) json_response(['error' => 'Name is required'], 422);
    $stmt = $pdo->prepare("INSERT INTO products (name, sku, price, stock, notes, created_at, updated_at) VALUES (?,?,?,?,?,NOW(),NOW())");
    $stmt->execute([$name, $sku, $price, $stock, $notes]);
    json_response(['message' => 'Created', 'id' => $pdo->lastInsertId()]);
    break;

  case 'update':
    verify_csrf();
    require_post();
    $id = (int)($_POST['id'] ?? 0);
    if (!$id) json_response(['error' => 'Missing id'], 422);
    $name = sanitize_text($_POST['name'] ?? '');
    $sku  = sanitize_text($_POST['sku'] ?? '');
    $price = (float)($_POST['price'] ?? 0);
    $stock = (int)($_POST['stock'] ?? 0);
    $notes = sanitize_text($_POST['notes'] ?? '');
    if (!$name) json_response(['error' => 'Name is required'], 422);
    $stmt = $pdo->prepare("UPDATE products SET name=?, sku=?, price=?, stock=?, notes=?, updated_at=NOW() WHERE id=?");
    $stmt->execute([$name, $sku, $price, $stock, $notes, $id]);
    json_response(['message' => 'Updated']);
    break;

  case 'delete':
    verify_csrf();
    require_post();
    $id = (int)($_POST['id'] ?? 0);
    if (!$id) json_response(['error' => 'Missing id'], 422);
    $stmt = $pdo->prepare("DELETE FROM products WHERE id=?");
    $stmt->execute([$id]);
    json_response(['message' => 'Deleted']);
    break;

  case 'export_csv':
    header('Content-Type: text/csv; charset=utf-8');
    header('Content-Disposition: attachment; filename=products.csv');
    $out = fopen('php://output', 'w');
    fputcsv($out, ['id','name','sku','price','stock','notes','created_at','updated_at']);
    foreach ($pdo->query("SELECT * FROM products ORDER BY id DESC") as $r) {
      fputcsv($out, [$r['id'],$r['name'],$r['sku'],$r['price'],$r['stock'],$r['notes'],$r['created_at'],$r['updated_at']]);
    }
    fclose($out);
    exit;

  default:
    json_response(['error' => 'Unknown action'], 400);
}
