<?php
require_once __DIR__ . '/../app/lib/session.php';
require_once __DIR__ . '/../app/lib/auth.php';
ensure_authenticated_page();
$active='invoices';
include __DIR__ . '/partials/header.php';
include __DIR__ . '/partials/topnav.php';
?>
<div class="container py-4" data-page="invoices">
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h1 class="h4 mb-0">Hisob-fakturalar</h1>
    <div>
      <a class="btn btn-outline-secondary me-2" href="/api/invoices.php?action=export_csv"><i class="bi bi-download"></i> Export CSV</a>
      <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#modalInvoice"><i class="bi bi-plus-lg"></i> Yangi</button>
    </div>
  </div>

  <div class="input-group mb-3">
    <input type="text" class="form-control" id="invSearch" placeholder="Qidirish...">
    <button class="btn btn-outline-secondary" id="invSearchBtn"><i class="bi bi-search"></i></button>
  </div>

  <div class="card shadow-sm">
    <div class="table-responsive">
      <table class="table table-hover align-middle mb-0">
        <thead class="table-light">
          <tr>
            <th>ID</th>
            <th>Mijoz</th>
            <th>Sana</th>
            <th>Jami</th>
            <th width="150">Amal</th>
          </tr>
        </thead>
        <tbody id="invTbody"></tbody>
      </table>
    </div>
    <div class="card-footer d-flex justify-content-between align-items-center">
      <div class="small text-secondary" id="invInfo"></div>
      <nav>
        <ul class="pagination mb-0" id="invPagination"></ul>
      </nav>
    </div>
  </div>
</div>

<!-- Modal: Invoice (create/edit) -->
<div class="modal fade" id="modalInvoice" tabindex="-1">
  <div class="modal-dialog modal-lg modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="modalInvoiceTitle">Yangi hisob-faktura</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body">
        <form id="invoiceForm">
          <input type="hidden" id="invoiceId">
          <div class="row g-3 mb-3">
            <div class="col-md-6">
              <label class="form-label">Mijoz</label>
              <select class="form-select" id="invoiceCustomer" required></select>
            </div>
            <div class="col-md-3">
              <label class="form-label">Sana</label>
              <input type="date" class="form-control" id="invoiceDate" required>
            </div>
            <div class="col-md-3">
              <label class="form-label">Izoh</label>
              <input type="text" class="form-control" id="invoiceNotes">
            </div>
          </div>

          <div class="table-responsive mb-2">
            <table class="table align-middle">
              <thead class="table-light">
                <tr>
                  <th>Mahsulot</th>
                  <th width="110">Miqdor</th>
                  <th width="140">Narx</th>
                  <th width="150">Jami</th>
                  <th width="50"></th>
                </tr>
              </thead>
              <tbody id="invoiceItems"></tbody>
            </table>
          </div>
          <button type="button" class="btn btn-outline-primary btn-sm mb-3" id="addItemBtn"><i class="bi bi-plus-lg"></i> Qator qo'shish</button>

          <div class="d-flex justify-content-end">
            <div class="text-end">
              <div class="text-secondary small">Jami summa</div>
              <div class="h4" id="invoiceTotal">0</div>
            </div>
          </div>
          <div class="text-danger small d-none" id="invError"></div>
        </form>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Yopish</button>
        <button class="btn btn-primary" id="saveInvoiceBtn">Saqlash</button>
      </div>
    </div>
  </div>
</div>

<!-- Modal: View Invoice -->
<div class="modal fade" id="modalInvoiceView" tabindex="-1">
  <div class="modal-dialog modal-lg modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Hisob-faktura</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body" id="invoiceViewBody"></div>
      <div class="modal-footer">
        <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Yopish</button>
      </div>
    </div>
  </div>
</div>
<?php include __DIR__ . '/partials/footer.php'; ?>
