<?php
require_once __DIR__ . '/../app/lib/session.php';
require_once __DIR__ . '/../app/lib/auth.php';
ensure_authenticated_page();
$active='products';
include __DIR__ . '/partials/header.php';
include __DIR__ . '/partials/topnav.php';
?>
<div class="container py-4" data-page="products">
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h1 class="h4 mb-0">Mahsulotlar</h1>
    <div>
      <a class="btn btn-outline-secondary me-2" href="/api/products.php?action=export_csv"><i class="bi bi-download"></i> Export CSV</a>
      <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#modalProduct"><i class="bi bi-plus-lg"></i> Yangi</button>
    </div>
  </div>

  <div class="input-group mb-3">
    <input type="text" class="form-control" id="prodSearch" placeholder="Qidirish...">
    <button class="btn btn-outline-secondary" id="prodSearchBtn"><i class="bi bi-search"></i></button>
  </div>

  <div class="card shadow-sm">
    <div class="table-responsive">
      <table class="table table-hover align-middle mb-0">
        <thead class="table-light">
          <tr>
            <th>ID</th>
            <th>Nomi</th>
            <th>SKU</th>
            <th>Narx</th>
            <th>Ombor</th>
            <th width="120">Amal</th>
          </tr>
        </thead>
        <tbody id="prodTbody"></tbody>
      </table>
    </div>
    <div class="card-footer d-flex justify-content-between align-items-center">
      <div class="small text-secondary" id="prodInfo"></div>
      <nav>
        <ul class="pagination mb-0" id="prodPagination"></ul>
      </nav>
    </div>
  </div>
</div>

<!-- Modal: Product -->
<div class="modal fade" id="modalProduct" tabindex="-1">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="modalProductTitle">Mahsulot</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
      </div>
      <form id="productForm">
        <input type="hidden" name="id" id="prodId">
        <div class="modal-body">
          <div class="mb-3">
            <label class="form-label">Nomi</label>
            <input type="text" class="form-control" name="name" id="prodName" required>
          </div>
          <div class="mb-3">
            <label class="form-label">SKU</label>
            <input type="text" class="form-control" name="sku" id="prodSku">
          </div>
          <div class="mb-3">
            <label class="form-label">Narx</label>
            <input type="number" step="0.01" class="form-control" name="price" id="prodPrice" required>
          </div>
          <div class="mb-3">
            <label class="form-label">Ombordagi miqdor</label>
            <input type="number" class="form-control" name="stock" id="prodStock" value="0" required>
          </div>
          <div class="mb-3">
            <label class="form-label">Izoh</label>
            <textarea class="form-control" name="notes" id="prodNotes" rows="2"></textarea>
          </div>
          <div class="text-danger small d-none" id="prodError"></div>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Yopish</button>
          <button class="btn btn-primary" type="submit">Saqlash</button>
        </div>
      </form>
    </div>
  </div>
</div>
<?php include __DIR__ . '/partials/footer.php'; ?>
