<?php
require_once '/home/dailslie/public_html/s3/app/lib/session.php';
require_once '/home/dailslie/public_html/s3/app/lib/helpers.php';
require_once '/home/dailslie/public_html/s3/app/config/database.php';

require_login();

$action = $_GET['action'] ?? 'list';

switch ($action) {
  case 'list':
    $q = trim($_GET['q'] ?? '');
    [$page, $per, $offset] = paginate_params();
    if ($q) {
      $stmt = $pdo->prepare("SELECT SQL_CALC_FOUND_ROWS i.*, c.name as customer_name
                              FROM invoices i
                              JOIN customers c ON c.id = i.customer_id
                              WHERE c.name LIKE :q OR i.id LIKE :q
                              ORDER BY i.id DESC LIMIT :offset, :per");
      $stmt->bindValue(':q', "%$q%");
      $stmt->bindValue(':offset', (int)$offset, PDO::PARAM_INT);
      $stmt->bindValue(':per', (int)$per, PDO::PARAM_INT);
      $stmt->execute();
    } else {
      $stmt = $pdo->prepare("SELECT SQL_CALC_FOUND_ROWS i.*, c.name as customer_name
                              FROM invoices i
                              JOIN customers c ON c.id = i.customer_id
                              ORDER BY i.id DESC LIMIT :offset, :per");
      $stmt->bindValue(':offset', (int)$offset, PDO::PARAM_INT);
      $stmt->bindValue(':per', (int)$per, PDO::PARAM_INT);
      $stmt->execute();
    }
    $data = $stmt->fetchAll();
    $total = $pdo->query("SELECT FOUND_ROWS() AS t")->fetch()['t'] ?? 0;
    json_response(['data' => $data, 'total' => (int)$total, 'page' => $page, 'per_page' => $per]);
    break;

  case 'get':
    $id = (int)($_GET['id'] ?? 0);
    $inv = $pdo->prepare("SELECT i.*, c.name as customer_name, c.phone, c.email, c.address
                          FROM invoices i
                          JOIN customers c ON c.id = i.customer_id
                          WHERE i.id = ?");
    $inv->execute([$id]);
    $invoice = $inv->fetch();
    if (!$invoice) json_response(['error' => 'Not found'], 404);
    $items = $pdo->prepare("SELECT ii.*, p.name as product_name, p.sku 
                            FROM invoice_items ii
                            JOIN products p ON p.id = ii.product_id
                            WHERE ii.invoice_id = ?");
    $items->execute([$id]);
    $invoice['items'] = $items->fetchAll();
    json_response($invoice);
    break;

  case 'create':
    verify_csrf();
    // expects JSON body: {customer_id, invoice_date, notes, items:[{product_id, quantity, unit_price}]}
    $body = get_json_body();
    $customer_id = (int)($body['customer_id'] ?? 0);
    $invoice_date = $body['invoice_date'] ?? date('Y-m-d');
    $notes = sanitize_text($body['notes'] ?? '');
    $items = $body['items'] ?? [];
    if (!$customer_id || !is_array($items) || count($items) === 0) {
      json_response(['error' => 'Invalid payload'], 422);
    }
    try {
      $pdo->beginTransaction();
      $total = 0;
      foreach ($items as $i) {
        $q = (int)($i['quantity'] ?? 0);
        $up = (float)($i['unit_price'] ?? 0);
        $total += $q * $up;
      }
      $stmt = $pdo->prepare("INSERT INTO invoices (customer_id, invoice_date, total_amount, notes, created_at) VALUES (?,?,?,?,NOW())");
      $stmt->execute([$customer_id, $invoice_date, $total, $notes]);
      $invoice_id = $pdo->lastInsertId();
      $itemStmt = $pdo->prepare("INSERT INTO invoice_items (invoice_id, product_id, quantity, unit_price, line_total) VALUES (?,?,?,?,?)");
      foreach ($items as $i) {
        $pid = (int)($i['product_id'] ?? 0);
        $q = (int)($i['quantity'] ?? 0);
        $up = (float)($i['unit_price'] ?? 0);
        $lt = $q * $up;
        $itemStmt->execute([$invoice_id, $pid, $q, $up, $lt]);
        // Decrease stock
        $pdo->prepare("UPDATE products SET stock = stock - ? WHERE id = ?")->execute([$q, $pid]);
      }
      $pdo->commit();
      json_response(['message' => 'Created', 'id' => $invoice_id]);
    } catch (Exception $e) {
      $pdo->rollBack();
      json_response(['error' => 'Failed to create invoice'], 500);
    }
    break;

  case 'update':
    verify_csrf();
    // expects JSON body: {id, customer_id, invoice_date, notes, items:[{id?, product_id, quantity, unit_price}]}
    $body = get_json_body();
    $id = (int)($body['id'] ?? 0);
    $customer_id = (int)($body['customer_id'] ?? 0);
    $invoice_date = $body['invoice_date'] ?? date('Y-m-d');
    $notes = sanitize_text($body['notes'] ?? '');
    $items = $body['items'] ?? [];
    if (!$id || !$customer_id) json_response(['error' => 'Invalid payload'], 422);

    try {
      $pdo->beginTransaction();
      // restore stock from old items
      $old = $pdo->prepare("SELECT product_id, quantity FROM invoice_items WHERE invoice_id = ?");
      $old->execute([$id]);
      foreach ($old->fetchAll() as $row) {
        $pdo->prepare("UPDATE products SET stock = stock + ? WHERE id = ?")->execute([$row['quantity'], $row['product_id']]);
      }
      // delete old items
      $pdo->prepare("DELETE FROM invoice_items WHERE invoice_id = ?")->execute([$id]);

      $total = 0;
      $itemStmt = $pdo->prepare("INSERT INTO invoice_items (invoice_id, product_id, quantity, unit_price, line_total) VALUES (?,?,?,?,?)");
      foreach ($items as $i) {
        $pid = (int)($i['product_id'] ?? 0);
        $q = (int)($i['quantity'] ?? 0);
        $up = (float)($i['unit_price'] ?? 0);
        $lt = $q * $up;
        $total += $lt;
        $itemStmt->execute([$id, $pid, $q, $up, $lt]);
        $pdo->prepare("UPDATE products SET stock = stock - ? WHERE id = ?")->execute([$q, $pid]);
      }
      $pdo->prepare("UPDATE invoices SET customer_id=?, invoice_date=?, total_amount=?, notes=? WHERE id=?")
          ->execute([$customer_id, $invoice_date, $total, $notes, $id]);

      $pdo->commit();
      json_response(['message' => 'Updated']);
    } catch (Exception $e) {
      $pdo->rollBack();
      json_response(['error' => 'Failed to update invoice'], 500);
    }
    break;

  case 'delete':
    verify_csrf();
    require_post();
    $id = (int)($_POST['id'] ?? 0);
    if (!$id) json_response(['error' => 'Missing id'], 422);
    try {
      $pdo->beginTransaction();
      // restore stock
      $old = $pdo->prepare("SELECT product_id, quantity FROM invoice_items WHERE invoice_id = ?");
      $old->execute([$id]);
      foreach ($old->fetchAll() as $row) {
        $pdo->prepare("UPDATE products SET stock = stock + ? WHERE id = ?")->execute([$row['quantity'], $row['product_id']]);
      }
      $pdo->prepare("DELETE FROM invoice_items WHERE invoice_id = ?")->execute([$id]);
      $pdo->prepare("DELETE FROM invoices WHERE id = ?")->execute([$id]);
      $pdo->commit();
      json_response(['message' => 'Deleted']);
    } catch (Exception $e) {
      $pdo->rollBack();
      json_response(['error' => 'Failed to delete invoice'], 500);
    }
    break;

  case 'export_csv':
    header('Content-Type: text/csv; charset=utf-8');
    header('Content-Disposition: attachment; filename=invoices.csv');
    $out = fopen('php://output', 'w');
    fputcsv($out, ['id','customer','invoice_date','total_amount','notes','created_at']);
    $q = $pdo->query("SELECT i.*, c.name AS customer FROM invoices i JOIN customers c ON c.id = i.customer_id ORDER BY i.id DESC");
    foreach ($q as $r) {
      fputcsv($out, [$r['id'], $r['customer'], $r['invoice_date'], $r['total_amount'], $r['notes'], $r['created_at']]);
    }
    fclose($out);
    exit;

  default:
    json_response(['error' => 'Unknown action'], 400);
}
