<?php
function json_response($data, $code = 200) {
  http_response_code($code);
  header('Content-Type: application/json; charset=utf-8');
  echo json_encode($data);
  exit;
}

function require_post() {
  if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    json_response(['error' => 'Method not allowed'], 405);
  }
}

function get_json_body() {
  $raw = file_get_contents('php://input');
  if (!$raw) return [];
  $data = json_decode($raw, true);
  if (json_last_error() !== JSON_ERROR_NONE) return [];
  return $data;
}

function sanitize_text($s) {
  return trim(filter_var($s, FILTER_SANITIZE_STRING, FILTER_FLAG_NO_ENCODE_QUOTES));
}

function require_login() {
  if (empty($_SESSION['user'])) {
    json_response(['error' => 'Unauthorized'], 401);
  }
}

function get_csrf_token() {
  if (empty($_SESSION['csrf'])) {
    $_SESSION['csrf'] = bin2hex(random_bytes(32));
  }
  return $_SESSION['csrf'];
}

function verify_csrf() {
  $token = $_SERVER['HTTP_X_CSRF_TOKEN'] ?? ($_POST['csrf'] ?? '');
  if (!$token || empty($_SESSION['csrf']) || !hash_equals($_SESSION['csrf'], $token)) {
    json_response(['error' => 'Invalid CSRF token'], 419);
  }
}

function paginate_params() {
  $page = max(1, (int)($_GET['page'] ?? 1));
  $per  = min(100, max(5, (int)($_GET['per_page'] ?? 10)));
  $offset = ($page - 1) * $per;
  return [$page, $per, $offset];
}

function db_now() {
  return date('Y-m-d H:i:s');
}
