<?php
require_once '/home/dailslie/public_html/s3/app/lib/session.php';
require_once '/home/dailslie/public_html/s3/app/lib/auth.php';
ensure_authenticated_page();
$active='customers';
include '/home/dailslie/public_html/s3/public/partials/header.php';
include '/home/dailslie/public_html/s3/public/partials/topnav.php';
?>
<div class="container py-4" data-page="customers">
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h1 class="h4 mb-0">Mijozlar</h1>
    <div>
      <a class="btn btn-outline-secondary me-2" href="/s3/api/customers.php?action=export_csv"><i class="bi bi-download"></i> Export CSV</a>
      <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#modalCustomer"><i class="bi bi-plus-lg"></i> Yangi</button>
    </div>
  </div>

  <div class="input-group mb-3">
    <input type="text" class="form-control" id="custSearch" placeholder="Qidirish...">
    <button class="btn btn-outline-secondary" id="custSearchBtn"><i class="bi bi-search"></i></button>
  </div>

  <div class="card shadow-sm">
    <div class="table-responsive">
      <table class="table table-hover align-middle mb-0">
        <thead class="table-light">
          <tr>
            <th>ID</th>
            <th>Ismi</th>
            <th>Telefon</th>
            <th>Email</th>
            <th>Manzil</th>
            <th width="120">Amal</th>
          </tr>
        </thead>
        <tbody id="custTbody"></tbody>
      </table>
    </div>
    <div class="card-footer d-flex justify-content-between align-items-center">
      <div class="small text-secondary" id="custInfo"></div>
      <nav>
        <ul class="pagination mb-0" id="custPagination"></ul>
      </nav>
    </div>
  </div>
</div>

<!-- Modal: Customer -->
<div class="modal fade" id="modalCustomer" tabindex="-1">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="modalCustomerTitle">Mijoz</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
      </div>
      <form id="customerForm">
        <input type="hidden" name="id" id="custId">
        <div class="modal-body">
          <div class="mb-3">
            <label class="form-label">Ism</label>
            <input type="text" class="form-control" name="name" id="custName" required>
          </div>
          <div class="mb-3">
            <label class="form-label">Telefon</label>
            <input type="text" class="form-control" name="phone" id="custPhone">
          </div>
          <div class="mb-3">
            <label class="form-label">Email</label>
            <input type="email" class="form-control" name="email" id="custEmail">
          </div>
          <div class="mb-3">
            <label class="form-label">Manzil</label>
            <textarea class="form-control" name="address" id="custAddress" rows="2"></textarea>
          </div>
          <div class="text-danger small d-none" id="custError"></div>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Yopish</button>
          <button class="btn btn-primary" type="submit">Saqlash</button>
        </div>
      </form>
    </div>
  </div>
</div>
<?php include '/home/dailslie/public_html/s3/public/partials/footer.php'; ?>
