<?php
require_once '/home/dailslie/public_html/s3/app/lib/session.php';
require_once '/home/dailslie/public_html/s3/app/lib/helpers.php';
require_once '/home/dailslie/public_html/s3/app/config/database.php';
require_login();
$action = $_GET['action'] ?? 'list';
switch ($action) {{
  case 'list':
    $q = trim($_GET['q'] ?? '');
    [$page, $per, $offset] = paginate_params();
    if ($q) {{
      $stmt = $pdo->prepare("SELECT SQL_CALC_FOUND_ROWS * FROM categories WHERE category_name LIKE :q ORDER BY id DESC LIMIT :offset, :per");
      $stmt->bindValue(':q', "%$q%");
      $stmt->bindValue(':offset', (int)$offset, PDO::PARAM_INT);
      $stmt->bindValue(':per', (int)$per, PDO::PARAM_INT);
      $stmt->execute();
    }} else {{
      $stmt = $pdo->prepare("SELECT SQL_CALC_FOUND_ROWS * FROM categories ORDER BY id DESC LIMIT :offset, :per");
      $stmt->bindValue(':offset', (int)$offset, PDO::PARAM_INT);
      $stmt->bindValue(':per', (int)$per, PDO::PARAM_INT);
      $stmt->execute();
    }}
    $data = $stmt->fetchAll();
    $total = $pdo->query("SELECT FOUND_ROWS() AS t")->fetch()['t'] ?? 0;
    json_response(['data' => $data, 'total' => (int)$total, 'page' => $page, 'per_page' => $per]);
    break;
  case 'get':
    $id = (int)($_GET['id'] ?? 0);
    $stmt = $pdo->prepare("SELECT * FROM categories WHERE id=?");
    $stmt->execute([$id]);
    $row = $stmt->fetch();
    if (!$row) json_response(['error' => 'Not found'], 404);
    json_response($row);
    break;
  case 'create':
    verify_csrf(); require_post();
    $name = sanitize_text($_POST['category_name'] ?? '');
    if (!$name) json_response(['error' => 'Name is required'], 422);
    $stmt = $pdo->prepare("INSERT INTO categories (category_name, created_at, updated_at) VALUES (?, NOW(), NOW())");
    $stmt->execute([$name]);
    json_response(['message' => 'Created', 'id' => $pdo->lastInsertId()]);
    break;
  case 'update':
    verify_csrf(); require_post();
    $id = (int)($_POST['id'] ?? 0);
    $name = sanitize_text($_POST['category_name'] ?? '');
    if (!$id || !$name) json_response(['error' => 'Invalid payload'], 422);
    $stmt = $pdo->prepare("UPDATE categories SET category_name=?, updated_at=NOW() WHERE id=?");
    $stmt->execute([$name, $id]);
    json_response(['message' => 'Updated']);
    break;
  case 'delete':
    verify_csrf(); require_post();
    $id = (int)($_POST['id'] ?? 0);
    if (!$id) json_response(['error' => 'Missing id'], 422);
    $stmt = $pdo->prepare("DELETE FROM categories WHERE id=?");
    $stmt->execute([$id]);
    json_response(['message' => 'Deleted']);
    break;
  case 'export_csv':
    header('Content-Type: text/csv; charset=utf-8');
    header('Content-Disposition: attachment; filename=categories.csv');
    $out = fopen('php://output', 'w');
    fputcsv($out, ['id','category_name','created_at','updated_at']);
    foreach ($pdo->query("SELECT * FROM categories ORDER BY id DESC") as $r) {{
      fputcsv($out, [$r['id'],$r['category_name'],$r['created_at'],$r['updated_at']]);
    }}
    fclose($out); exit;
  default:
    json_response(['error' => 'Unknown action'], 400);
}}
