<?php
require_once '/home/dailslie/public_html/s3/app/lib/session.php';
require_once '/home/dailslie/public_html/s3/app/lib/helpers.php';
require_once '/home/dailslie/public_html/s3/app/config/database.php';
require_login();
$action = $_GET['action'] ?? 'list';
switch ($action) {
  case 'list':
    $q = trim($_GET['q'] ?? '');
    [$page, $per, $offset] = paginate_params();
    if ($q) {
      $stmt = $pdo->prepare("SELECT SQL_CALC_FOUND_ROWS * FROM expenses WHERE note LIKE :q OR category LIKE :q ORDER BY id DESC LIMIT :offset, :per");
      $stmt->bindValue(':q', "%$q%");
      $stmt->bindValue(':offset', (int)$offset, PDO::PARAM_INT);
      $stmt->bindValue(':per', (int)$per, PDO::PARAM_INT);
      $stmt->execute();
    } else {
      $stmt = $pdo->prepare("SELECT SQL_CALC_FOUND_ROWS * FROM expenses ORDER BY id DESC LIMIT :offset, :per");
      $stmt->bindValue(':offset', (int)$offset, PDO::PARAM_INT);
      $stmt->bindValue(':per', (int)$per, PDO::PARAM_INT);
      $stmt->execute();
    }
    $data = $stmt->fetchAll();
    $total = $pdo->query("SELECT FOUND_ROWS() AS t")->fetch()['t'] ?? 0;
    json_response(['data' => $data, 'total' => (int)$total, 'page' => $page, 'per_page' => $per]);
    break;
  case 'get':
    $id = (int)($_GET['id'] ?? 0);
    $stmt = $pdo->prepare("SELECT * FROM expenses WHERE id=?");
    $stmt->execute([$id]);
    $row = $stmt->fetch();
    if (!$row) json_response(['error' => 'Not found'], 404);
    json_response($row);
    break;
  case 'create':
    verify_csrf(); require_post();
    $date = $_POST['date'] ?? date('Y-m-d');
    $category = sanitize_text($_POST['category'] ?? '');
    $amount = (float)($_POST['amount'] ?? 0);
    $note = sanitize_text($_POST['note'] ?? '');
    if (!$category || $amount<=0) json_response(['error'=>'Invalid payload'], 422);
    $stmt = $pdo->prepare("INSERT INTO expenses (date, category, amount, note, created_at, updated_at) VALUES (?,?,?,?,NOW(),NOW())");
    $stmt->execute([$date, $category, $amount, $note]);
    json_response(['message'=>'Created','id'=>$pdo->lastInsertId()]);
    break;
  case 'update':
    verify_csrf(); require_post();
    $id = (int)($_POST['id'] ?? 0);
    $date = $_POST['date'] ?? date('Y-m-d');
    $category = sanitize_text($_POST['category'] ?? '');
    $amount = (float)($_POST['amount'] ?? 0);
    $note = sanitize_text($_POST['note'] ?? '');
    if (!$id || !$category || $amount<=0) json_response(['error'=>'Invalid payload'], 422);
    $stmt = $pdo->prepare("UPDATE expenses SET date=?, category=?, amount=?, note=?, updated_at=NOW() WHERE id=?");
    $stmt->execute([$date, $category, $amount, $note, $id]);
    json_response(['message'=>'Updated']);
    break;
  case 'delete':
    verify_csrf(); require_post();
    $id = (int)($_POST['id'] ?? 0);
    if (!$id) json_response(['error'=>'Missing id'], 422);
    $stmt = $pdo->prepare("DELETE FROM expenses WHERE id=?");
    $stmt->execute([$id]);
    json_response(['message'=>'Deleted']);
    break;
  case 'export_csv':
    header('Content-Type: text/csv; charset=utf-8');
    header('Content-Disposition: attachment; filename=expenses.csv');
    $out = fopen('php://output', 'w');
    fputcsv($out, ['id','date','category','amount','note','created_at','updated_at']);
    foreach ($pdo->query("SELECT * FROM expenses ORDER BY id DESC") as $r) {
      fputcsv($out, [$r['id'],$r['date'],$r['category'],$r['amount'],$r['note'],$r['created_at'],$r['updated_at']]);
    }
    fclose($out); exit;
  default:
    json_response(['error'=>'Unknown action'], 400);
}
