<?php
require __DIR__.'/../../config/config.php';
spl_autoload_register(function($class){
  $prefix = 'App\\'; $baseDir = __DIR__ . '/../../src/';
  if (strncmp($prefix, $class, strlen($prefix)) !== 0) return;
  $rel = substr($class, strlen($prefix));
  $file = $baseDir . str_replace('\\','/',$rel) . '.php';
  if (file_exists($file)) require $file;
});
use App\Core\DB; use App\Core\Export; use App\Core\Auth;
session_start();
if(!Auth::id()){ header('HTTP/1.1 403 Forbidden'); echo '403 — Avtorizatsiya talab qilinadi'; exit; }
$entity = $_GET['entity'] ?? 'products';
$format = strtolower($_GET['format'] ?? 'csv');
$map = [
  'products' => "SELECT id,code,name,uom,brand,category FROM products ORDER BY id DESC LIMIT 5000",
  'customers'=> "SELECT id,code,name,phone,email,region,segment FROM customers ORDER BY id DESC LIMIT 5000",
  'invoices' => "SELECT id,code,date,customer_id,status,total FROM invoices ORDER BY id DESC LIMIT 5000",
  'orders'   => "SELECT id,code,date,customer_id,status,total FROM sales_orders ORDER BY id DESC LIMIT 5000",
  'shipments'=> "SELECT id,code,date,customer_id,warehouse_id,status,total,cogs_total FROM shipments ORDER BY id DESC LIMIT 5000",
  'bank'     => "SELECT id,date,descr,debit,credit,status FROM bank_statements ORDER BY id DESC LIMIT 5000"
];
$sql = $map[$entity] ?? $map['products'];
$rows = DB::all($sql);
$fname = $entity.'.'.$format;
switch($format){
  case 'json': Export::json($rows,$fname); break;
  case 'xml': Export::xml($rows,$fname); break;
  case 'xls': Export::xls($rows,$fname); break;
  case 'doc': Export::doc($rows,$fname); break;
  default: Export::csv($rows,$fname);
}
