<?php
namespace App\Controllers\Admin;
use App\Core\Controller; use App\Core\DB; use App\Core\Response;
class DiagnosticsController extends Controller {
  public function index(){
    $env = [
      'php' => PHP_VERSION,
      'pdo_mysql' => extension_loaded('pdo_mysql') ? 'yes' : 'no',
      'base_url' => Response::baseUrl(),
      'upload_dir' => UPLOAD_DIR
    ];
    $dbok = true; $tables=[]; $miss=[]; $msg=null;
    $need = ['users','roles','customers','suppliers','products','warehouses','price_lists','prices',
      'sales_orders','sales_order_items','invoices','invoice_items','shipments','shipment_items',
      'cost_layers','stock_transactions','attachments','bank_statements'];
    try {
      $rows = DB::all("SHOW TABLES");
      foreach($rows as $r){ $tables[] = array_values($r)[0]; }
      foreach($need as $t){ if(!in_array($t, $tables)) $miss[]=$t; }
    } catch(\Throwable $e){ $dbok=false; $msg=$e->getMessage(); }
    $this->view('admin/diagnostics/index', compact('env','dbok','tables','miss','msg'));
  }
}
