<?php
namespace App\Core;
class Export {
  public static function csv(array $rows, string $filename='export.csv'){
    header('Content-Type: text/csv; charset=utf-8');
    header('Content-Disposition: attachment; filename='.$filename);
    $out=fopen('php://output','w'); if(!$rows){ fclose($out); return; }
    fputcsv($out, array_keys($rows[0]));
    foreach($rows as $r) fputcsv($out, $r);
    fclose($out);
  }
  public static function json(array $rows, string $filename='export.json'){
    header('Content-Type: application/json'); header('Content-Disposition: attachment; filename='.$filename);
    echo json_encode($rows, JSON_UNESCAPED_UNICODE|JSON_PRETTY_PRINT);
  }
  public static function xml(array $rows, string $filename='export.xml'){
    header('Content-Type: application/xml'); header('Content-Disposition: attachment; filename='.$filename);
    echo "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<rows>";
    foreach($rows as $r){ echo "<row>"; foreach($r as $k=>$v){ echo "<".htmlspecialchars($k).">".htmlspecialchars((string)$v)."</".htmlspecialchars($k).">"; } echo "</row>"; }
    echo "</rows>";
  }
  public static function xls(array $rows, string $filename='export.xls'){
    header('Content-Type: application/vnd.ms-excel'); header('Content-Disposition: attachment; filename='.$filename);
    echo "<table border='1'><tr>"; if($rows){ foreach(array_keys($rows[0]) as $h) echo "<th>".htmlspecialchars($h)."</th>"; echo "</tr>";
      foreach($rows as $r){ echo "<tr>"; foreach($r as $v) echo "<td>".htmlspecialchars((string)$v)."</td>"; echo "</tr>"; }
    } else { echo "</tr>"; } echo "</table>";
  }
  public static function doc(array $rows, string $filename='export.doc'){
    header('Content-Type: application/msword'); header('Content-Disposition: attachment; filename='.$filename);
    echo "<html><body><table border='1' style='border-collapse:collapse'>";
    if($rows){ echo "<tr>"; foreach(array_keys($rows[0]) as $h) echo "<th>".htmlspecialchars($h)."</th>"; echo "</tr>";
      foreach($rows as $r){ echo "<tr>"; foreach($r as $v) echo "<td>".htmlspecialchars((string)$v)."</td>"; echo "</tr>"; }
    }
    echo "</table></body></html>";
  }
}
