<?php
namespace App\Core;
class Response {
  public static function basePath(): string {
    $p = str_replace('\\','/', dirname($_SERVER['SCRIPT_NAME'] ?? '/'));
    if ($p === '' || $p === '.') $p = '/';
    if ($p[0] !== '/') $p = '/'.$p;
    return rtrim($p,'/');
  }
  public static function schemeHost(): string {
    $isHttps = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') || (($_SERVER['SERVER_PORT'] ?? null) == 443);
    $sch = $isHttps ? 'https://' : 'http://';
    $host = $_SERVER['HTTP_HOST'] ?? 'localhost';
    return $sch.$host;
  }
  public static function baseUrl(): string { return self::schemeHost().self::basePath(); }
  public static function url(string $route): string { $route = ltrim($route,'?/'); return self::baseUrl()."/index.php?r=".$route; }
  public static function redirect(string $route): void { header("Location: ".self::url($route)); exit; }
  public static function alert(string $type, string $msg): void {
    echo "<link href='assets/bootstrap.min.css' rel='stylesheet'><div class='container p-3'><div class='alert alert-"
      .htmlspecialchars($type)."'><b>".htmlspecialchars(strtoupper($type))."</b><div class='small'>".htmlspecialchars($msg)."</div></div></div>";
  }
}
