<?php
namespace App\Core;
/**
 * Robust Router with auth shortcut:
 *   ?r=auth/login  → App\Controllers\AuthController::login
 *   ?r=auth/logout → App\Controllers\AuthController::logout
 */
class Router {
  public static function handle(){
    // Session cookie path = app base
    $bp = str_replace('\\','/', dirname($_SERVER['SCRIPT_NAME'] ?? '/'));
    if ($bp === '' || $bp === '.') $bp = '/';
    if ($bp[0] !== '/') $bp = '/'.$bp;
    session_set_cookie_params(['lifetime'=>0,'path'=>$bp ?: '/','httponly'=>true,'samesite'=>'Lax']);
    if(session_status()!==PHP_SESSION_ACTIVE) session_start();

    // Resolve route from ?r=... or path-style
    $r = $_GET['r'] ?? null;
    if(!$r){
      $uri = parse_url($_SERVER['REQUEST_URI'] ?? '', PHP_URL_PATH);
      $uri = trim($uri,'/');
      $base = trim($bp,'/');
      if($base && strpos($uri,$base)===0){ $uri = trim(substr($uri, strlen($base)), '/'); }
      if(($pos=strpos($uri,'index.php'))!==false){ $uri = trim(substr($uri, $pos+9),'/'); }
      $r = $uri;
    }
    $r = trim($r??'', '/');
    // Strip :line:col (console)
    $r = preg_replace('/:[0-9]+(?::[0-9]+)?$/','',$r);

    $parts = array_values(array_filter(explode('/', $r)));
    // Normalize
    if(count($parts)==0){ $parts=['admin','dashboard','index']; }
    if(count($parts)==1){ $parts[]='dashboard'; $parts[]='index'; }
    if(count($parts)==2){
      // Special short-hands
      if ($parts[0]==='auth' && in_array($parts[1], ['login','logout'])) {
        $parts=['auth','auth',$parts[1]]; // AuthController::login/logout
      } else {
        $parts[]='index'; // default action
      }
    }

    foreach($parts as &$p){ $p = preg_replace('~[^a-zA-Z0-9_]+~','',$p); if($p==='') $p='index'; }
    list($module,$controller,$action) = $parts;

    $map=[
      'admin'    => "App\\Controllers\\Admin\\%sController",
      'catalog'  => "App\\Modules\\Catalog\\Controllers\\%sController",
      'sales'    => "App\\Modules\\Sales\\Controllers\\%sController",
      'inventory'=> "App\\Modules\\Inventory\\Controllers\\%sController",
      'finance'  => "App\\Modules\\Finance\\Controllers\\%sController",
      'files'    => "App\\Modules\\Files\\Controllers\\%sController",
      'auth'     => "App\\Controllers\\%sController",
      'reports'  => "App\\Modules\\Reports\\Controllers\\%sController"
    ];
    if(!isset($map[$module])){
      $_SESSION['flash'] = "Noma'lum modul: {$module} — Bosh sahifaga yo'naltirildi";
      \App\Core\Response::redirect('admin/dashboard/index');
    }
    $class = sprintf($map[$module], ucfirst($controller));
    if(!class_exists($class)){
      $_SESSION['flash'] = "Controller topilmadi: {$class} — Diagnostikaga yo'naltirildi";
      \App\Core\Response::redirect('admin/diagnostics/index');
    }
    $inst = new $class();
    if(!method_exists($inst, $action)){
      $_SESSION['flash'] = "Action topilmadi: {$class}::{$action} — Diagnostikaga yo'naltirildi";
      \App\Core\Response::redirect('admin/diagnostics/index');
    }
    try { $inst->$action(); }
    catch(\Throwable $e){
      http_response_code(500);
      echo "<link rel='stylesheet' href='assets/bootstrap.min.css'><div class='container p-3'><div class='alert alert-danger'><b>500 — Ichki xatolik</b><div class='small'>".htmlspecialchars($e->getMessage())."</div></div>";
      if(defined('APP_DEBUG') && APP_DEBUG){
        echo "<pre class='small bg-light p-2 border'>".htmlspecialchars($e->getTraceAsString())."</pre>";
      }
      echo "</div>"; exit;
    }
  }
}
