<?php
namespace App\Modules\Sales\Controllers;
use App\Core\Controller; use App\Core\DB; use App\Core\Auth; use App\Core\Inventory;
class ShipmentsController extends Controller {
  public function index(){ Auth::requireLogin();
    $rows=DB::all("SELECT * FROM shipments ORDER BY id DESC LIMIT 300");
    $prod=DB::all("SELECT id,code,name FROM products ORDER BY name LIMIT 1000");
    $this->view('sales/shipments/index', compact('rows','prod'));
  }
  public function create(){ Auth::requireLogin();
    $wh=(int)($_POST['warehouse_id']??1);
    DB::exec("INSERT INTO shipments(code,date,customer_id,warehouse_id,status,total,cogs_total) VALUES(?,?,?,?, 'NEW',0,0)",[ $_POST['code'], $_POST['date'], (int)($_POST['customer_id']??0), $wh ]);
    $sid=DB::lastId(); $total=0; $cogs=0;
    foreach($_POST['product_id']??[] as $i=>$pid){
      if(!$pid) continue; $qty=(float)$_POST['qty'][$i]; $price=(float)$_POST['price'][$i]; $method=strtoupper($_POST['method'][$i]??'FIFO');
      try{ if($method==='FEFO') Inventory::issueFefo($wh,(int)$pid,$qty); else Inventory::issueFifo($wh,(int)$pid,$qty); }
      catch(\Throwable $e){ $_SESSION['flash']='Zaxira xatosi: '.$e->getMessage(); \App\Core\Response::redirect('sales/shipments/index'); return; }
      $line=$qty*$price; $total+=$line;
      $last=(float)(DB::one("SELECT ABS(amount) FROM stock_transactions WHERE type='OUT' AND product_id=? AND warehouse_id=? ORDER BY id DESC LIMIT 1",[(int)$pid,$wh]) ?: 0);
      $cogs += $last;
      DB::exec("INSERT INTO shipment_items(shipment_id,product_id,qty,price,total,cogs,method) VALUES(?,?,?,?,?,?,?)",[$sid,(int)$pid,$qty,$price,$line,$last,$method]);
    }
    DB::exec("UPDATE shipments SET total=?, cogs_total=? WHERE id=?",[$total,$cogs,$sid]);
    $_SESSION['flash']='Jo‘natma yaratildi'; \App\Core\Response::redirect('sales/shipments/index');
  }
  public function delete(){ Auth::requireLogin(); DB::exec("DELETE FROM shipments WHERE id=?",[(int)$_POST['id']]); $_SESSION['flash']='O‘chirildi'; \App\Core\Response::redirect('sales/shipments/index'); }
}
