<?php
namespace App\Core;
use PDO; use PDOException;
class DB {
  private static ?PDO $pdo = null;
  private static function pdo(): PDO {
    if(self::$pdo===null){
      $opt=[PDO::ATTR_ERRMODE=>PDO::ERRMODE_EXCEPTION, PDO::ATTR_DEFAULT_FETCH_MODE=>PDO::FETCH_ASSOC];
      self::$pdo = new PDO(DB_DSN, DB_USER, DB_PASS, $opt);
      self::$pdo->exec("SET NAMES utf8mb4");
    }
    return self::$pdo;
  }
  public static function exec(string $sql, array $params=[]): int { $st=self::pdo()->prepare($sql); $st->execute($params); return $st->rowCount(); }
  public static function all(string $sql, array $params=[]): array { $st=self::pdo()->prepare($sql); $st->execute($params); return $st->fetchAll(); }
  public static function row(string $sql, array $params=[]): ?array { $r=self::all($sql,$params); return $r[0] ?? null; }
  public static function one(string $sql, array $params=[]){ $st=self::pdo()->prepare($sql); $st->execute($params); return $st->fetchColumn(); }
  public static function lastId(): int { return (int)self::pdo()->lastInsertId(); }
}
