<?php
namespace App\Core;
class Response {
  public static function asset(string $path): string { $path=ltrim($path,'/'); return self::baseUrl().'/'.$path; }
  public static function link(string $route): string { return self::url($route); }
  public static function basePath(): string {
    $p = str_replace('\\','/', dirname($_SERVER['SCRIPT_NAME'] ?? '/'));
    if ($p === '' || $p === '.') $p = '/';
    if ($p[0] !== '/') $p = '/'.$p;
    return rtrim($p,'/');
  }
  public static function schemeHost(): string {
    $isHttps = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') || (($_SERVER['SERVER_PORT'] ?? null) == 443);
    $sch = $isHttps ? 'https://' : 'http://';
    $host = $_SERVER['HTTP_HOST'] ?? 'localhost';
    return $sch.$host;
  }
  public static function baseUrl(): string { return self::schemeHost().self::basePath(); }
  public static function url(string $route): string { $route=ltrim($route,'?/'); return self::baseUrl()."/index.php?r=".$route; }
  public static function redirect(string $route): void { header("Location: ".self::url($route)); exit; }
  public static function error(int $code, string $msg): void {
    http_response_code($code);
    echo "<link href='assets/bootstrap.min.css' rel='stylesheet'><div class='container p-3'>"
       ."<div class='alert alert-danger'><b>{$code} — Xatolik</b><div class='small'>".htmlspecialchars($msg)."</div></div></div>";
    exit;
  }
}
