<?php
namespace App\Core;
class Router {
  public static function handle(){
    // session cookie path
    $bp = str_replace('\\','/', dirname($_SERVER['SCRIPT_NAME'] ?? '/'));
    if ($bp === '' || $bp === '.') $bp = '/';
    if ($bp[0] !== '/') $bp = '/'.$bp;
    session_set_cookie_params(['lifetime'=>0,'path'=>$bp ?: '/','httponly'=>true,'samesite'=>'Lax']);
    if(session_status()!==PHP_SESSION_ACTIVE) session_start();

    // resolve route (query or path), strip :line:col
    $r = $_GET['r'] ?? null;
    if(!$r){
      $uri = parse_url($_SERVER['REQUEST_URI'] ?? '', PHP_URL_PATH);
      $uri = trim($uri,'/');
      if(($pos=strpos($uri,'index.php'))!==false){ $uri = trim(substr($uri, $pos+9),'/'); }
      $parts = array_values(array_filter(explode('/', $uri)));
      if(count($parts)>=3){ $r = implode('/', array_slice($parts,0,3)); }
    }
    if(!$r){
      // default: if logged in -> dashboard, else -> login
      $r = isset($_SESSION['uid']) ? 'admin/dashboard/index' : 'auth/login';
    }

    $r = preg_replace('/:[0-9]+(?::[0-9]+)?$/','',$r);
    if(!preg_match('~^[a-zA-Z0-9_]+/[a-zA-Z0-9_]+/[a-zA-Z0-9_]+$~', $r)){
      Response::error(400, "Bad route format. Use ?r=module/controller/action");
    }
    list($module,$controller,$action) = explode('/', $r);
    $map=[
      'admin'    => "App\\Controllers\\Admin\\%sController",
      'catalog'  => "App\\Modules\\Catalog\\Controllers\\%sController",
      'sales'    => "App\\Modules\\Sales\\Controllers\\%sController",
      'inventory'=> "App\\Modules\\Inventory\\Controllers\\%sController",
      'finance'  => "App\\Modules\\Finance\\Controllers\\%sController",
      'files'    => "App\\Modules\\Files\\Controllers\\%sController",
      'auth'     => "App\\Controllers\\%sController"
    ];
    if(!isset($map[$module])) Response::error(404, "Noma'lum modul: {$module}");
    $class = sprintf($map[$module], ucfirst($controller));
    if(!class_exists($class)) Response::error(404, "Controller topilmadi: {$class}");
    $inst = new $class();
    if(!method_exists($inst, $action)) Response::error(404, "Action topilmadi: {$class}::{$action}");
    $inst->$action();
  }
}
